package no.statnett.ecp.brs;

import java.util.Map;


/**
 * Contains necessary information about the configuration of the main broker + extra logins to additional brokers
 */
public class Config {
    private Map<String, String> brokerConfig;
    private Map<String, Login> extraLogins;

    public Config(Map<String, String> brokerConfig, Map<String, Login> extraLogins) {
        this.brokerConfig = brokerConfig;
        this.extraLogins = extraLogins;
    }

    public Map<String, Login> getExtraLogins() {
        return extraLogins;
    }

    public String get(String key) {
        return brokerConfig.get(key);
    }
}
