package no.statnett.ecp.brs.state;

import java.util.ArrayList;
import java.util.List;

public class MessageFilter {

  private FilterResult msrt = new FilterResult("=", 0, null);  // Default sort - no sorting
  private FilterResult mage = new FilterResult("=", -1, null); // Default filter - matches ALL
  private FilterResult mtyp = new FilterResult(null, null, null); // Default filter - matches ALL
  private FilterResult mbid = new FilterResult(null, null, null); // Default filter - matches ALL
  private FilterResult msnd = new FilterResult(null, null, null); // Default filter - matches ALL
  private FilterResult mrcv = new FilterResult(null, null, null); // Default filter - matches ALL
  private FilterResult mlim = new FilterResult("=", 0, null); // Default listing - lists ALL

  public FilterResult getMsrt() {
    return msrt;
  }

  public void setMsrt(FilterResult msrt) {
    this.msrt = msrt;
  }

  public FilterResult getMage() {
    return mage;
  }

  public void setMage(FilterResult mage) {
    this.mage = mage;
  }

  public FilterResult getMtyp() {
    return mtyp;
  }

  public void setMtyp(FilterResult mtyp) {
    this.mtyp = mtyp;
  }

  public FilterResult getMbid() {
    return mbid;
  }

  public void setMbid(FilterResult mbid) {
    this.mbid = mbid;
  }

  public FilterResult getMsnd() {
    return msnd;
  }

  public void setMsnd(FilterResult msnd) {
    this.msnd = msnd;
  }

  public FilterResult getMrcv() {
    return mrcv;
  }

  public void setMrcv(FilterResult mrcv) {
    this.mrcv = mrcv;
  }

  public FilterResult getMlim() {
    return mlim;
  }

  public void setMlim(FilterResult mlim) {
    this.mlim = mlim;
  }

  public String getFilterStr() {
    List<String> filters = new ArrayList<>();
    if (mage.number() < 0) { // age-filter will always be added, because the Artemis API require some filter (not empty string)
      filters.add("%28AMQTimestamp%3E0%29");
    } else {
      long minAgeMillis = mage.number() * 60 * 1000L;
      long now = System.currentTimeMillis();
      long minAge = now - minAgeMillis;
      if (mage.op().equals(">"))
        filters.add("%28AMQTimestamp%3C" + minAge + "%29");
      if (mage.op().equals("<"))
        filters.add("%28AMQTimestamp%3E" + minAge + "%29");
      if (mage.op().equals("=")) {
        long maxAge = minAge - 60 * 1000L + 1;
        filters.add("%28AMQTimestamp%3C" + minAge + "%29%20AND%20%28AMQTimestamp%3E" + maxAge + "%29");
      }
    }
    if (mtyp.arg() != null)
      filters.add(createFilterExpression(mtyp.arg(), "messageType", "businessType", "EDX_MESSAGE_TYPE"));
    if (mbid.arg() != null)
      filters.add(createFilterExpression(mbid.arg(), "baMessageId", "EDX_BA_MESSAGE_ID"));
    if (msnd.arg() != null)
      filters.add(createFilterExpression(msnd.arg(), "sender", "senderCode", "EDX_SENDER"));
    if (mrcv.arg() != null)
      filters.add(createFilterExpression(mrcv.arg(), "receiver", "receiverCode", "EDX_RECEIVER_CODE"));

    return String.join("%20AND%20", filters);

  }

  private String createFilterExpression(String filter, String... propertyNames) {
    String equal = "%3D";
    String unequal = "%3C%3E";
    String like = "%20LIKE%20";
    String unlike = "%20NOT%20LIKE%20";
    boolean not = filter.startsWith("!");
    filter = not ? filter.substring(1) : filter; // remove the ! if present

    String operator = filter.contains("%") ? (not ? unlike : like) : (not ? unequal : equal);
    String filterEscaped = filter.replace("%", "%25"); // Escape % in the message type
    List<String> elements = new ArrayList<>();
    for (String propertyName : propertyNames) {
      elements.add(propertyName + operator + "%27" + filterEscaped + "%27");
    }
    String filterTranslated = "%28" + String.join("%20OR%20", elements) + "%29";
    return filterTranslated;
  }
}
