package no.statnett.ecp.cds.state;

public class MessagePathFilter {
    private String stat;
    private String code;
    private String broker;
    private String messageType;

    public String getStat() {
        return stat;
    }

    public String getStatExplained() {
        if (stat == null || stat.equals("aaaa")) {
            return "<ALL>";
        } else {
            String statExplained = stat + " (";
            char c = stat.charAt(0);
            if (c == 'a') {
                statExplained += "Valid & Invalid, ";
            } else if (c == 'y') {
                statExplained += "Only Valid, ";
            } else if (c == 'n') {
                statExplained += "Only Invalid, ";
            } else if (c == '?') {
                statExplained += "Unknown Validity, ";
            }

            c = stat.charAt(1);
            if (c == 'a') {
                statExplained += "Connected & Disconnected, ";
            } else if (c == 'y') {
                statExplained += "Only Connected, ";
            } else if (c == 'n') {
                statExplained += "Only Disconnected, ";
            } else if (c == '?') {
                statExplained += "Unknown ConnectStatus, ";
            }

            c = stat.charAt(2);
            if (c == 'a') {
                statExplained += "Local & Central, ";
            } else if (c == 'y') {
                statExplained += "Only Local, ";
            } else if (c == 'n') {
                statExplained += "Only Central, ";
            } else if (c == '?') {
                statExplained += "Unknown Locality, ";
            }

            c = stat.charAt(3);
            if (c == 'a') {
                statExplained += "Active & Inactive";
            } else if (c == 'y') {
                statExplained += "Only Active";
            } else if (c == 'n') {
                statExplained += "Only Inactive";
            } else if (c == '?') {
                statExplained += "Unknown Status";
            }
            statExplained += ")";
            return statExplained;
        }
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBroker() {
        return broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }
}
