package no.statnett.ecp.cds.state;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;

public class MessagePathInfo {
    private Integer id;
    private String broker;
    private String messageType;
    private String senders;
    private String validFrom;
    private String  validTo;
    private boolean local;
    private boolean skip;

    // Added to this object at a later stage
    private Boolean connected;
    private boolean active;

    public MessagePathInfo(Integer id, String broker, String messageType, List<String> senders, String validFrom, String validTo, boolean local) {
        this.id = id;
        this.broker = broker;
        this.messageType = messageType;
        this.senders = senders.stream().collect(Collectors.joining(","));
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.local = local;
    }

    public Integer getId() {
        return id;
    }

    public String getBroker() {
        return broker;
    }

    public String getMessageType() {
        return messageType;
    }

    public String getSenders() {
        return senders;
    }

    public String getValidFrom() {
        return validFrom;
    }

    public String getValidTo() {
        return validTo;
    }

    public boolean isValid() {
        // Convert validFrom into a timestamp
        LocalDateTime now = LocalDateTime.now();
        if (validFrom != null) {
            LocalDateTime validFromLDT = LocalDateTime.parse(validFrom);
            if (validTo != null) {
                LocalDateTime validToLDT = LocalDateTime.parse(validTo);
                return validFromLDT.isBefore(now) && validToLDT.isAfter(now);
            } else {
                return validFromLDT.isBefore(now);
            }
        }
        return false;
    }

    public boolean isLocal() {
        return local;
    }

    public Boolean isConnected() {
        return connected;
    }

    public void setConnected(Boolean connected) {
        this.connected = connected;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isSkip() {
        return skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}
