package no.statnett.ecp.eml;

import no.statnett.ecp.utils.Const;
import no.statnett.ecp.utils.Div;
import no.statnett.ecp.utils.Options;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;

public class DummyLogger {
    // Decide how far back the dummy log should go:
    private final static int days = 90;

    public static void main(String[] args) throws IOException {
        // Create a file to output a logline that is repeated every QH for a week:

        File emlLog = Options.checkFile("eml-dummy.log", true);
        if (emlLog.exists()) {
            emlLog.delete();
            emlLog.createNewFile();
        }
        File ecpLog = Options.checkFile("ecp.log", true);
        if (ecpLog.exists()) {
            ecpLog.delete();
            ecpLog.createNewFile();
        }



        ZonedDateTime zdt = ZonedDateTime.now(ZoneId.of("UTC")).minusDays(days);
        int qh = days * 24 * 4;
        for (int i = 0; i < qh; i++) {
            String logMsg = logMsg(zdt);
            Files.writeString(emlLog.toPath(), logMsg + "\n", StandardOpenOption.APPEND);
            zdt = zdt.plusMinutes(15);
        }

        // Write a few loglines to ecp.log - starting from a timestamp AFTER the last logline in eml-dummy.log
        zdt = zdt.plusMinutes(1);
        for (int i = 0; i < 5; i++) {
            // A ecp-log line starts like this (we don't care about the rest of the line):
            // 2024-08-15 09:12:15.051  INFO 2551619 --- [taskScheduler-4] EcpAuditLog
            String ecpLogMsg = zdt.format(Const.localTmsMillisecNotISO) + " INFO 2551619 --- [taskScheduler-4] EcpAuditLog";
            Files.writeString(ecpLog.toPath(), ecpLogMsg + "\n", StandardOpenOption.APPEND);
            zdt = zdt.plusSeconds(10);
        }
    }


    private static String logMsg(ZonedDateTime zdt) {
        String weekNo = Div.calcWeek(zdt);
        int qh = Div.calcQH(zdt.toInstant().toEpochMilli());

        String dir = "SEND";
        String ack = "Y";
        String delay = "OK";
        int ms = 4951;
        String remote = "50V-KINECT---ATZ";
        String broker = "50V000000000112U";
        String local = "50V-SN-DKBSP-AT2";
        String msgId = UUID.randomUUID().toString();
        int sizeKB = 3;
        String msgType = "NBM-MFRREAM-CIM-PTA47-MTA39";
        String baMsgId = UUID.randomUUID().toString();
        String senderApp = "EML";
        return ECPMsgLogger.makeLogline(zdt, weekNo, qh, dir, ack, delay, ms, remote, broker, local, msgId, sizeKB, msgType, baMsgId, senderApp);
    }
}
