package no.statnett.ecp.qp;

import jakarta.jms.*;
import no.statnett.ecp.utils.LogOut;
import no.statnett.ecp.utils.EcpMsg;

import java.util.Enumeration;

public class Browse {

    public static void updateCountersAndWaitMs(Session session, Destination destination, Counters counters, LoopState loopState) throws JMSException {
        QueueBrowser browser = session.createBrowser((Queue) destination);
        Enumeration<?> enum1 = browser.getEnumeration();
        int browserCounter = 0;
        while (enum1.hasMoreElements()) {
            Object melding = enum1.nextElement();
            processBrowse((Message) melding, counters);
            browserCounter++;
        }
        browser.close();
        counters.setBrowserCounter(browserCounter);

        if (loopState.getLastMode() == Mode.RESTORE) {
            int qReduction = loopState.getLastBrowserCounter() - browserCounter; // LastBrowserCounter is a number between 0 and 10, since restore will not be allowed unless queue is almost empty
            if (qReduction > loopState.getMsgRestored() || browserCounter < 2) {
                loopState.setWaitMs((int) (loopState.getWaitMs() * 0.9f)); // restore can be done faster
                System.out.println(LogOut.i() + "Restore could be quicker, waitMs between each restore is decreased by 10% to " + loopState.getWaitMs() + " ms");
            } else if (qReduction < 0) {
                loopState.setWaitMs((int) (loopState.getWaitMs() * 1.5f)); // restore must be done slower
                System.out.println(LogOut.i() + "Restore is too quick, waitMs between each restore is increased by 50% to " + loopState.getWaitMs() + " ms");
            } else {
                // waitMs = waitMs; // restore can be done at the same speed
            }
        }

    }

    private static void processBrowse(Message msg, Counters counters) throws JMSException {
        counters.updateNoMsgPrAgeSec(EcpMsg.calculateAgeSeconds(msg));

        String sender = EcpMsg.getSender(msg);
        if (sender != null && !sender.isEmpty()) {
            counters.updateNoMsgPrSender(sender);
        }
        String internalType = EcpMsg.getInternalType(msg);
        if (internalType != null) {
            counters.updateNoMsgPrInternalType(internalType);
        }
    }


}
