package no.statnett.ecp.utils;

import no.statnett.ecp.eml.ECPMsgLogger;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public class DebugLog {

    private static File debugFile;
    private static boolean defaultToStdOut;

    public DebugLog(File debugFile, boolean defaultToStdout) {
        this.debugFile = debugFile;
        this.defaultToStdOut = defaultToStdout;
    }


    public void debug(String message) {
        debug(message, null);
    }

    public void debug(String message, Exception e) {
        try {
            String logLine = LogOut.d() + " " + message + "\n";
            if (e != null) {
                logLine += LogOut.e() + " " + message + " Exception: " + e.getMessage() + ",  Stacktrace: " + Div.onelinerStacktrace(e.getStackTrace(), "no.statnett.ecp") + "\n";
            }
            if (debugFile != null) {
                if (debugFile.exists()) {
                    if (debugFile.length() > 10000000) {// 10MB (arbitrary limit - will be removed if exceeded
                        Files.delete(debugFile.toPath());
                        Files.writeString(debugFile.toPath(), LogOut.d() + " Deleted previous debug-file since it exceeded 10MB - starting over\n");
                    }
                    Files.writeString(debugFile.toPath(), logLine, StandardOpenOption.APPEND);
                } else
                    Files.writeString(debugFile.toPath(), logLine);
            } else if (defaultToStdOut) {
                System.out.print(logLine);
            }
        } catch (IOException ioe) {
            System.err.println("Error occurred during printing to debug-file " + debugFile.getAbsoluteFile() + ": " + ioe.getMessage());
            System.exit(1);
        }
    }
}
