package no.statnett.ecp.utils;

import java.time.ZonedDateTime;

import static java.time.ZoneOffset.UTC;

public class Div {
    public static String onelinerStacktrace(StackTraceElement[] stackTrace, String ownPackages) {
        StringBuilder sb = new StringBuilder();
        boolean foundOwnPackages = false;
        for (int i = 0; i < stackTrace.length; i++) {
            boolean ownClassesFound = stackTrace[i].getClassName().contains(ownPackages);
            if (ownClassesFound) {
                foundOwnPackages = true;
            }
            if (foundOwnPackages && !ownClassesFound) {
                continue;
            }
            sb.append(stackTrace[i].getClassName() + ":" + stackTrace[i].getLineNumber() + "." + stackTrace[i].getMethodName() + " <-- ");
        }

        String stacktrace = sb.toString();
        if (stacktrace.endsWith(" <-- ")) {
            stacktrace = stacktrace.substring(0, stacktrace.length() - 5);
        }
        return stacktrace;
    }

    public static int calcQH(long tms) {
        return (int) ((tms - Const.MS_20200101) / Const.MS_QUARTERHOUR);
    }

    public static ZonedDateTime calcZDTFromQH(int qh) {
        return ZonedDateTime.ofInstant(java.time.Instant.ofEpochMilli(Const.MS_20200101 + qh * Const.MS_QUARTERHOUR), UTC);
    }

    public static String calcWeek(ZonedDateTime tmsZDT) {
        return tmsZDT.format(Const.tmsNumberWeek);
    }
}
