package no.statnett.ecp.utils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class EcpHTTP {
  public static String getECPHTTResponse(String method, URL url, String user, String pw, String body) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    Map<String, String> requestHeaders = getStringStringMap(url, user, pw);
    return HTTP.retrieveResponseBody(method, url, user, pw, requestHeaders, body);
  }

  public static byte[] getECPHTTResponseAsBytes(String method, URL url, String user, String pw, String body) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    Map<String, String> requestHeaders = getStringStringMap(url, user, pw);
    return HTTP.retrieveResponseBodyAsBytes(method, url, user, pw, requestHeaders, body);
  }

  public static void put(URL url, String user, String pw, byte[] bytes) throws NoSuchAlgorithmException, IOException, KeyManagementException {
    Map<String, String> requestHeaders = getStringStringMap(url, user, pw);
    HTTP.uploadFile(url, user, pw, requestHeaders, bytes);
  }


  private static Map<String, String> getStringStringMap(URL url, String user, String pw) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    Map<String, String> requestHeaders = new HashMap<>(Map.of("Accept", "application/json"));
    // This URL works on ECP 4.17, no other URL works. It also works on 4.12-4.16 since it redirects to correct login-page. It also works EDX 1.13-1.16.
    // Somehow it should not work on EDX 1.17 (if I test this URL in browser it fails) - but it does
    // Same with Artemis...
    URL loginURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/ECP_MODULE/gui/login");
    HttpURLConnection connection = HTTP.connect("GET", loginURL, user, pw, requestHeaders, null);
    String XSRF = "XSRF-TOKEN";
    String JSESSIONID = "JSESSIONID";
    String xsrfToken = getCookieValue(connection, XSRF);
    String jsessionid = getCookieValue(connection, JSESSIONID);
    requestHeaders.put("Cookie", XSRF + "=" + xsrfToken + "; " + JSESSIONID + "=" + jsessionid + "; role=admin");
    requestHeaders.put("X-Xsrf-Token", xsrfToken);
    requestHeaders.put("Content-Type", "application/json;charset=UTF-8");
    return requestHeaders;
  }

  private static String getCookieValue(HttpURLConnection connection, String cookieKey) {
    for (String headerKeys : connection.getHeaderFields().keySet()) {
      int i = 0;
      for (String header : connection.getHeaderFields().get(headerKeys)) {
        if (header != null && header.contains(cookieKey)) {
          String cookie = header;
          int cookieStartPos = cookie.indexOf(cookieKey + "=") + cookieKey.length() + 1;
          int cookieEndPos = cookie.indexOf(";", cookieStartPos);
          if (cookieEndPos == -1) {
            return cookie.substring(cookieStartPos);
          } else {
            return cookie.substring(cookieStartPos, cookieEndPos);
          }
        }
      }
    }
    return null;
  }
}
