package no.statnett.ecp.utils;

import javax.net.ssl.*;
import java.io.*;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;

public class HTTP {
  public static String retrieveResponseBody(String method, URL url, String username, String password, Map<String, String> requestHeaders, String requestPayload) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    HttpURLConnection connection = connect(method, url, username, password, requestHeaders, requestPayload);

    try {
      BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getResponseCode() == 200 || connection.getResponseCode() == 204 ? connection.getInputStream() : connection.getErrorStream(), StandardCharsets.UTF_8));
      String line;
      StringBuilder builder = new StringBuilder();
      while ((line = bufferedReader.readLine()) != null) {
        builder.append(line + "\n");
      }
      bufferedReader.close();
      connection.disconnect();
      return builder.toString();
    } catch (Exception e) {
      if (e.getClass() != ConnectException.class) {
        System.out.println("\nError occurred: Connection to URL: " + url + " using user/pass " + username + "/*****");
      }
      throw e;
    }
  }

  public static byte[] retrieveResponseBodyAsBytes(String method, URL url, String username, String password, Map<String, String> requestHeaders, String requestPayload) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    HttpURLConnection connection = connect(method, url, username, password, requestHeaders, requestPayload);
    try {
      if (connection.getResponseCode() == 200) {
        InputStream inputStream = connection.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] temp = new byte[4096];
        int bytesRead;
        while ((bytesRead = inputStream.read(temp)) != -1) {
          buffer.write(temp, 0, bytesRead);
        }
        return buffer.toByteArray();
      } else {
        System.out.println("\nError occured, HTTP-return-code is " + connection.getResponseCode() + ", message: " + connection.getResponseMessage());
        throw new RuntimeException("The server could not retrieve " + url + " ");
      }
    } catch (Exception e) {
      if (e.getClass() != ConnectException.class) {
        System.out.println("\nError occurred: Connection to URL: " + url + " using user/pass " + username + "/*****");
      }
      throw e;
    }
  }

  public static void uploadFile(URL url, String username, String password, Map<String, String> requestHeaders, byte[] file) throws NoSuchAlgorithmException, IOException, KeyManagementException {
    HttpURLConnection connection = uploadBytes("PUT", url, username, password, requestHeaders, file);
    try {
      if (connection.getResponseCode() != 200) {
        System.out.println("\nError occured, HTTP-return-code is " + connection.getResponseCode() + ", message: " + connection.getResponseMessage());
        throw new RuntimeException("The server could not retrieve " + url + " ");
      }
    } catch (Exception e) {
      if (e.getClass() != ConnectException.class) {
        System.out.println("\nError occurred: Connection to URL: " + url + " using user/pass " + username + "/*****");
      }
      throw e;
    }

  }

  // Performs Basic Authentication, handles both HTTP and HTTPS (but disregards certificate validation) -
  public static HttpURLConnection connect(String method, URL url, String username, String password, Map<String, String> requestHeaders, String requestPayload) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    byte[] requestBytes = null;
    if (requestPayload != null) {
      requestBytes = requestPayload.getBytes(StandardCharsets.UTF_8);
    }
    return connectWithBytes(method, url, username, password, requestHeaders, requestBytes);
  }

  public static HttpURLConnection connectWithBytes(String method, URL url, String username, String password, Map<String, String> requestHeaders, byte[] requestBytes) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    HttpURLConnection connection = getHttpURLConnection(url, username, password);

    try {
      connection.setRequestMethod(method);
      for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
        connection.setRequestProperty(entry.getKey(), entry.getValue());
      }

      if (username != null && password != null) {
        // Step 6: Add Basic Authentication
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeader = "Basic " + encodedAuth;
        connection.setRequestProperty("Authorization", authHeader);
      }

      if (requestBytes != null) {
        connection.setDoOutput(true);
        connection.getOutputStream().write(requestBytes);
      }
      connection.connect();
    } catch (Exception e) {
      if (e.getClass() != ConnectException.class) {
        System.out.println("\nError occurred: Connection to URL: " + url + " using user/pass " + username + "/*****");
      }
      throw e;
    }

    return connection;
  }

  public static HttpURLConnection uploadBytes(String method, URL url, String username, String password, Map<String, String> requestHeaders, byte[] bytes) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    HttpURLConnection connection = getHttpURLConnection(url, username, password);

    try {
      connection.setRequestMethod(method);
      connection.setDoOutput(true);
      for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
        connection.setRequestProperty(entry.getKey(), entry.getValue());
      }

      if (username != null && password != null) {
        // Step 6: Add Basic Authentication
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeader = "Basic " + encodedAuth;
        connection.setRequestProperty("Authorization", authHeader);
      }

      String boundary = "----WebKitFormBoundary"+System.currentTimeMillis();
      requestHeaders.put("Content-Type", "multipart/form-data; boundary=" + boundary);

      connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);

      try (OutputStream outputStream = connection.getOutputStream()) {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"), true);

        writer.append("--" + boundary + "\r\n");
        writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"import.zip\"\r\n");
        writer.append("Content-Type: application/x-zip-compressed\r\n");
        writer.append("\r\n");
        writer.flush();

        outputStream.write(bytes);
        outputStream.flush();

        writer.append("\r\n");
        writer.append("--" + boundary + "--\r\n");
        writer.flush();
      }

    } catch (Exception e) {
      if (e.getClass() != ConnectException.class) {
        System.out.println("\nError occurred: Connection to URL: " + url + " using user/pass " + username + "/*****");
      }
      throw e;
    }

    return connection;
  }

  private static HttpURLConnection getHttpURLConnection(URL url, String username, String password) throws NoSuchAlgorithmException, KeyManagementException, IOException {
    HttpURLConnection connection;
    try {
      if (url.getProtocol().equals("https")) {
        // Step 2: Set up a TrustManager that trusts all certificates
        TrustManager[] trustAll = new TrustManager[]{
            new X509TrustManager() {
              @Override
              public X509Certificate[] getAcceptedIssuers() {
                return null;
              }

              @Override
              public void checkClientTrusted(X509Certificate[] certs, String authType) {
              }

              @Override
              public void checkServerTrusted(X509Certificate[] certs, String authType) {
              }
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAll, null);

        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());

        // Step 4: Set up a HostnameVerifier that accepts all hostnames
        HostnameVerifier allHostsValid = (hostname, session) -> true;
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);

        // Step 5: Open a connection
        connection = (HttpsURLConnection) url.openConnection();

      } else {
        // Step 5: Open a connection
        connection = (HttpURLConnection) url.openConnection();

      }
    } catch (Exception e) {
      if (e.getClass() != ConnectException.class) {
        System.out.println("\nError occurred: Connection to URL: " + url + " using user/pass " + username + "/*****");
      }
      throw e;
    }
    return connection;
  }
}
