package no.statnett.ecp.brs;

import no.statnett.ecp.brs.state.QueueInfo;
import no.statnett.ecp.utils.LogOut;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public class Div {
    public static String user(Config config, QueueInfo qi) {
        if (qi == null)
            return config.get("user");
        Map<String, Login> extraLogins = config.getExtraLogins();
        return extraLogins.get(qi.getHost()) != null && extraLogins.get(qi.getHost()).getUser() != null ? extraLogins.get(qi.getHost()).getUser() : config.get("user");
    }

    public static String pass(Config config, QueueInfo qi) {
        if (qi == null)
            return config.get("password");
        Map<String, Login> extraLogins = config.getExtraLogins();
        return extraLogins.get(qi.getHost()) != null && extraLogins.get(qi.getHost()).getPassword() != null ? extraLogins.get(qi.getHost()).getPassword() : config.get("password");
    }

    public static String prot(Config config, QueueInfo qi) {
        // The protocol may or may not have been specified by the user input
        String protocol = config.get("suggest") == null ? "https" : config.get("suggest").equals("tls") ? "https" : "http";
        // Override the above protocol if specified in the extraLogins-file
        if (qi != null) {
            Map<String, Login> extraLogins = config.getExtraLogins();
            if (extraLogins.get(qi.getHost()) != null && extraLogins.get(qi.getHost()).getProtocol() != null)
                protocol = extraLogins.get(qi.getHost()).getProtocol();
        }
        return protocol;
    }

    public static File getValidFileReferenceForWrite(String filename) {
        File file = new File(filename);
        try {
            if (file.exists()) {
                Files.writeString(file.toPath(), "", StandardOpenOption.APPEND);
            } else {
                Files.writeString(file.toPath(), "");
            }
            return file;
        } catch (IOException e) {
            System.out.println(LogOut.e() + "Cannot write to '" + filename + "' (exception: " + e.getMessage() + ")");
            return null;
        }
    }


}
