package no.statnett.ecp.brs.state;

import no.statnett.ecp.utils.Const;

public class ConsumerInfo {
  private String host;
  private String queueName;
  private long creationTime;
  private String consumerID;
  private String connectionID;
  private boolean browseOnly;
  private int deliveredCount;
  private int inTransitCount;
  private int acknowledgedCount;
  private String ipAddress;
  private int port;
  private long lastDeliveredTime;
  private long lastAcknowledgedTime;


  public String getHost() {
    return host;
  }

  public void setHost(String host) {
    this.host = host;
  }

  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  public long getCreationTime() {
    return creationTime;
  }

  public void setCreationTime(long creationTime) {
    this.creationTime = creationTime;
  }

  public String getConsumerID() {
    return consumerID;
  }

  public void setConsumerID(String consumerID) {
    this.consumerID = consumerID;
  }

  public String getConnectionID() {
    return connectionID;
  }

  public void setConnectionID(String connectionID) {
    this.connectionID = connectionID;
  }

  public boolean isBrowseOnly() {
    return browseOnly;
  }

  public void setBrowseOnly(boolean browseOnly) {
    this.browseOnly = browseOnly;
  }

  public int getDeliveredCount() {
    return deliveredCount;
  }

  public void setDeliveredCount(int deliveredCount) {
    this.deliveredCount = deliveredCount;
  }

  public int getInTransitCount() {
    return inTransitCount;
  }

  public void setInTransitCount(int inTransitCount) {
    this.inTransitCount = inTransitCount;
  }

  public int getAcknowledgedCount() {
    return acknowledgedCount;
  }

  public void setAcknowledgedCount(int acknowledgedCount) {
    this.acknowledgedCount = acknowledgedCount;
  }

  public String getIpAddress() {
    return ipAddress;
  }

  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }

  public int getPort() {
    return port;
  }

  public void setPort(int port) {
    this.port = port;
  }

  public long getLastDeliveredTime() {
    return lastDeliveredTime;
  }

  public void setLastDeliveredTime(long lastDeliveredTime) {
    this.lastDeliveredTime = lastDeliveredTime;
  }

  public long getLastAcknowledgedTime() {
    return lastAcknowledgedTime;
  }

  public void setLastAcknowledgedTime(long lastAcknowledgedTime) {
    this.lastAcknowledgedTime = lastAcknowledgedTime;
  }

  public int getAge() {
    long lastMsgTms = Math.max(getLastDeliveredTime(), getLastAcknowledgedTime());
    return lastMsgTms <= 0 ? -1 : ((int) ((System.currentTimeMillis() - lastMsgTms) / 60000));
  }


  public String toString() {
    String creationStr = getCreationTime() > 0
        ? java.time.Instant.ofEpochMilli(getCreationTime()).atZone(java.time.ZoneId.systemDefault()).toLocalDateTime().format(Const.localTmsSec)
        : "";
    long lastMsgTms = Math.max(getLastDeliveredTime(), getLastAcknowledgedTime());
    String lastMsgStr = lastMsgTms > 0
        ? java.time.Instant.ofEpochMilli(lastMsgTms).atZone(java.time.ZoneId.systemDefault()).toLocalDateTime().format(Const.localTmsSec)
        : "";
    return getHost() + " | " + getQueueName() + " | " + creationStr + " | " + lastMsgStr + " | " + getConnectionID() + " | "
        + getInTransitCount() + " | " + getAcknowledgedCount() + " | " + getIpAddress() + " | " + getPort();
  }


}
