package no.statnett.ecp.brs.state;

import java.util.ArrayList;
import java.util.List;


/*
 * This class contains the information about the queues we're currently interested in (due to the filters) and
 * also the messages that we might or might not have listed from those queues. Queue- and message-operations can
 * be performed on an individual queue or message, or on all queues or messages in the state. The order of the list
 * is important, because it is the 'id' used if individual operations are performed.
 */
public class State {
    List<MessageInfo> miList;
    List<QueueInfo> qiList;

    public State() {
        this.miList = new ArrayList<>();
        this.qiList = new ArrayList<>();
    }

    public List<MessageInfo> getMiList() {
        return miList;
    }

    public void setMiList(List<MessageInfo> miList) {
        this.miList = miList;
    }

    public List<QueueInfo> getQiList() {
        return qiList;
    }

    public void setQiList(List<QueueInfo> qiList) {
        this.qiList = qiList;
    }
}
