package no.statnett.ecp.cds.state;

public class CertFilter {
  private FilterResult rsrt;
  private FilterResult rtyp;
  private FilterResult rsta;
  private FilterResult rpre;
  private FilterResult ract;
  private FilterResult rval;
  private FilterResult rlim;

  public CertFilter() {
    reset();
  }

  public void reset() {
    rsrt = new FilterResult("=", 0, null); // Default sort - no sorting
    rtyp = new FilterResult(null, null, null); // Default filter - matches ALL
    rsta = new FilterResult(null, null, null); // Default filter - matches ALL
    rpre = new FilterResult(null, null, null); // Default filter - matches ALL
    ract = new FilterResult(null, null, null); // Default filter - matches ALL
    rval = new FilterResult(null, null, null); // Default filter - matches ALL
    rlim = new FilterResult("=", 0, null); // Default listing - lists ALL
  }

  public FilterResult getRsrt() {
    return rsrt;
  }

  public void setRsrt(FilterResult rsrt) {
    this.rsrt = rsrt;
  }

  public FilterResult getRtyp() {
    return rtyp;
  }

  public void setRtyp(FilterResult rtyp) {
    this.rtyp = rtyp;
  }

  public FilterResult getRsta() {
    return rsta;
  }

  public void setRsta(FilterResult rsta) {
    this.rsta = rsta;
  }

  public FilterResult getRpre() {
    return rpre;
  }

  public void setRpre(FilterResult rpre) {
    this.rpre = rpre;
  }

  public FilterResult getRact() {
    return ract;
  }

  public void setRact(FilterResult ract) {
    this.ract = ract;
  }

  public FilterResult getRval() {
    return rval;
  }

  public void setRval(FilterResult rval) {
    this.rval = rval;
  }

  public FilterResult getRlim() {
    return rlim;
  }

  public void setRlim(FilterResult rlim) {
    this.rlim = rlim;
  }
}


