package no.statnett.ecp.edx;

import java.util.*;

class Combination {

  /*
   arr[]       ---> Input Array
   tmp[]       ---> Temporary array to store current combination
   start & end ---> Starting and Ending indexes in arr[]
   index       ---> Current index in tmp[]
   r           ---> Size of a combination to be printed
  */
  private static List<Integer[]> combinationUtil(int arr[], int tmp[], int start, int end, int index, int r) {
    if (index == r) {
      List<Integer[]> tmpList = new ArrayList<>();
      tmpList.add(Arrays.stream( tmp ).boxed().toArray( Integer[]::new ));
      return tmpList;
    }

    // replace index with all possible elements. The condition "end-i+1 >= r-index" makes sure that including one element
    // at index will make a combination with remaining elements at remaining positions
    List<Integer[]> listOfIntegers = new ArrayList<>();
    for (int i = start; i <= end && end - i + 1 >= r - index; i++) {
      tmp[index] = arr[i];
      listOfIntegers.addAll(combinationUtil(arr, tmp, i + 1, end, index + 1, r));
    }
    return listOfIntegers;
  }


  // this method is merely a bridge between the logic of the above method and the outside world
  // the logic above requires int[], but in EDXMonitor we like to work with Collections (Sets, Lists)
  public static List<Set<Integer>> getCombinationSets(int max, int length) {
    int[] arr = new int[max];
    for (int i = 0; i < max; i++) {
      arr[i] = i;
    }
    int r = length;
    int tmp[] = new int[r];
    List<Integer[]> list = combinationUtil(arr, tmp, 0, arr.length - 1, 0, r);
    List<Set<Integer>> sets = new ArrayList<>();
    for (Integer[] integers : list) {
      Set<Integer> set = new HashSet<>();
      for (Integer integer : integers) {
        set.add(integer);
      }
      sets.add(set);
    }
    return sets;
  }
//
//  public static void main(String[] args) {
//    List<Set<Integer>> list = getCombinationSets(5, 1);
//
//    // print list
//    for (Set<Integer> integerSet : list) {
//      for (Integer integer : integerSet) {
//        System.out.print(integer + " ");
//      }
//      System.out.println();
//    }
//  }



}