package no.statnett.ecp.emd;

public class StandardSummary {

  // "timestamp": "2023-06-23 08:00:00.000Z", "direction": "snd",
  private String time; // yyyy-MM eller yyyy-MM-dd
  private String direction; // snd/rcv


  private long cnt; // count
  private long cntDel; // count delayed
  private long cntExp; // count expired
  private long totMs; // total duration
  private long totMsDel; // total duration delayed
  private long totMsExp; // total duration expired

  public StandardSummary(String time, String direction, String line) {
    this.time = time;
    this.direction = direction;
    add(line);
  }

  public String getTime() {
    return time;
  }

  // line: "cnt": 1520, "cntDel":    0, "cntExp":    0, "avgMs":    756, "avgMsDel":      0, "avgMsExp":      0, "avgKB":     6, "avgKBDel":     0, "avgKBExp":     0, "maxMs":    4285, "maxKB":    10
  public StandardSummary add(String line) {
    String[] array = line.split(",");
    long cnt = get(array[0]);
    long cntDel = get(array[1]);
    long cntExp = get(array[2]);
    long avgMs = get(array[3]);
    long avgMsDel = get(array[4]);
    long avgMsExp = get(array[5]);
    long totMs = cnt * avgMs;
    long totMsDel = cntDel * avgMsDel;
    long totMsExp = cntExp * avgMsExp;

    this.cnt += cnt;
    this.cntDel += cntDel;
    this.cntExp += cntExp;
    this.totMs += totMs;
    this.totMsDel += totMsDel;
    this.totMsExp += totMsExp;
    return this;
  }

  private long get(String cell) {
    return Long.parseLong(cell.split(":")[1].trim());
  }

  public String print() {
    StringBuffer sb = new StringBuffer();
    long cntOK = cnt - cntDel - cntExp;
    long avgMs = cnt > 0 ? totMs / cnt : 0;
    long avgMsOK = cntOK > 0 ? (totMs - totMsDel - totMsExp) / (cntOK) : 0;
    long avgMsDel = cntDel > 0 ? totMsDel / cntDel : 0;
    long avgMsExp = cntExp > 0 ? totMsExp / cntExp : 0;

    if (time.length() == 7) {
      sb.append("{ \"month\": \"").append(time).append("\",    ");
    } else {
      sb.append("{  \"date\": \"").append(time).append("\", ");
    }

    sb.append("\"direction\": \"").append(direction).append("\", ").
      append("\"cnt\": ").append(String.format("%7d", cnt)).append(", ").
      append("\"cntOK\": ").append(String.format("%7d", cntOK)).append(", ").
      append("\"cntDel\": ").append(String.format("%5d", cntDel)).append(", ").
      append("\"cntExp\": ").append(String.format("%5d", cntExp)).append(", ").
      append("\"avgMs\": ").append(String.format("%9d", avgMs)).append(", ").
      append("\"avgMsOK\": ").append(String.format("%4d", avgMsOK)).append(", ").
      append("\"avgMsDel\": ").append(String.format("%5d", avgMsDel)).append(", ").
      append("\"avgMsExp\": ").append(String.format("%10d", avgMsExp)).append(", ").
      append("\"percentOK\": ").append(String.format("%6.2f", 100.0 * cntOK / cnt)).append(", "). // 100.0 * cntOK / cnt
      append("\"percentDel\": ").append(String.format("%6.2f", 100.0 * cntDel / cnt)).append(", "). // 100.0 * cntDel / cnt
      append("\"percentExp\": ").append(String.format("%6.2f", 100.0 * cntExp / cnt)). // 100.0 * cntExp / cnt
      append(" }\n");
    return sb.toString();
  }

}
