package no.statnett.ecp.pf;

import jakarta.jms.CompletionListener;
import jakarta.jms.Message;

import java.util.concurrent.atomic.AtomicInteger;

public class ProduceCounter implements CompletionListener {

  private AtomicInteger msgInBuffer = new AtomicInteger(0);
  private AtomicInteger msgProducedCounter = new AtomicInteger(0);
  private AtomicInteger msgProducedCounterTotal = new AtomicInteger(0);
  private AtomicInteger skip = new AtomicInteger(0);
  private int msgSizeB;

  public ProduceCounter(int msgSizeB) {
    this.msgSizeB = msgSizeB;
  }

  public void messageSent() {
    msgInBuffer.incrementAndGet();
  }

  public boolean aboveLimit(long limitB) {
    return getCurrentBufferSizeB() > limitB;
  }

  public long getCurrentBufferSizeB() {
    return msgInBuffer.get() * (long) msgSizeB;
  }

  public void increaseSkip() {
    skip.incrementAndGet();
  }

  public int resetSkip() {
    return skip.getAndSet(0);
  }

  @Override
  public void onCompletion(Message message) {
    msgProducedCounter.incrementAndGet();
    msgProducedCounterTotal.incrementAndGet();
    msgInBuffer.decrementAndGet();
    if (msgInBuffer.get() < 0)
      msgInBuffer.set(0);
  }

  public int resetMsgProducedCounter() {
    return msgProducedCounter.getAndSet(0);
  }

  public int getMsgProducedCounter() {
    return msgProducedCounter.get();
  }

  public int getMsgProducedCounterTotal() {
    return msgProducedCounterTotal.get();
  }

  @Override
  public void onException(Message message, Exception exception) {
    System.out.println("Error occurred when trying to send a message: " + exception);
  }
}
