package no.statnett.ecp.qp;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Counters {
    private Map<String, Integer> noMsgPrSender = new TreeMap<>();
    private Map<Long, Integer> noMsgPrAgeSec = new TreeMap<>();
    private Map<String, Integer> noMsgPrInternalType = new TreeMap<>();
    private int browserCounter = 0;

    public Map<String, Integer> getNoMsgPrSender() {
        return noMsgPrSender;
    }

    public Map<Long, Integer> getNoMsgPrAgeSec() {
        return noMsgPrAgeSec;
    }

    public Map<String, Integer> getNoMsgPrInternalType() {
        return noMsgPrInternalType;
    }

    public void updateNoMsgPrAgeSec(long ageSeconds) {
        noMsgPrAgeSec.merge(ageSeconds, 1, Integer::sum);
    }

    public void updateNoMsgPrSender(String sender) {
        noMsgPrSender.merge(sender, 1, Integer::sum);
    }

    public void updateNoMsgPrInternalType(String internalType) {
        noMsgPrInternalType.merge(internalType, 1, Integer::sum);
    }

    public int getBrowserCounter() {
        return browserCounter;
    }

    public void setBrowserCounter(int browserCounter) {
        this.browserCounter = browserCounter;
    }

    public Set<String> getSenders(int maxPrSender) {
        // Search each sender and if the number of messages is greater-or-equal than maxPrSender - make a new list of those senders
        return noMsgPrSender.entrySet().stream()
                .filter(e -> e.getValue() >= maxPrSender)
                .map(Map.Entry::getKey)
                .collect(java.util.stream.Collectors.toSet());
    }
}
