package no.statnett.ecp.qp;

public class LoopState {
    public Mode lastMode = Mode.MONITOR;
    public long lastLoggedTms = -1;
    private int lastBrowserCounter = 0;
    private int msgRestored = 0;
    private boolean firstLoop = true;
    private boolean continuous;
    private int waitMs;

    public LoopState(boolean continuous, int waitMs) {
        this.continuous = continuous;
        this.waitMs = waitMs;
    }

    public int getWaitMs() {
        return waitMs;
    }

    public void setWaitMs(int waitMs) {
        this.waitMs = waitMs;
    }

    public Mode getLastMode() {
        return lastMode;
    }

    public void setLastMode(Mode lastMode) {
        this.lastMode = lastMode;
    }

    public long getLastLoggedTms() {
        return lastLoggedTms;
    }

    public void setLastLoggedTms(long lastLoggedTms) {
        this.lastLoggedTms = lastLoggedTms;
    }

    public int getLastBrowserCounter() {
        return lastBrowserCounter;
    }

    public int getMsgRestored() {
        return msgRestored;
    }

    public void setLastBrowserCounter(int lastBrowserCounter) {
        this.lastBrowserCounter = lastBrowserCounter;
    }

    public void setMsgRestored(int msgRestored) {
        this.msgRestored = msgRestored;
    }

    public void sleep() {
        if (firstLoop) {
            firstLoop = false;
        } else {
            try {
                if (lastMode == Mode.MONITOR || lastMode == Mode.RSTWAIT) {
                    Thread.sleep(10000);
                } else if (lastMode == Mode.RESTORE) {
                    Thread.sleep(getWaitMs());
                } else {
                    Thread.sleep(1000); // PROTECT-mode, we sleep 1 second between each protection loop + consuming
                }
            } catch (InterruptedException e) {
                // do nothing
            }
        }
    }

    public boolean isContinuous() {
        return continuous;
    }
}
