package no.statnett.ecp.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.List;

public class Options {


  public static File checkFile(String filename, boolean write) {
    File file = new File(filename);
    if (write) {
      try {
        if (file.exists()) {
          Files.writeString(file.toPath(), "", StandardOpenOption.APPEND);
        } else {
          Files.writeString(file.toPath(), "");
        }
        return file;
      } catch (IOException e) {
        System.err.println(LogOut.e() + "Cannot write to '" + filename + "' (exception: " + e.getMessage() + ")");
        System.exit(1);
        return null; // System exists before this anyway
      }
    } else {
      if (!file.exists()) {
        System.err.println(LogOut.e() + "Did not find file '" + file.getAbsolutePath() + "'");
        System.exit(1);
      } else if (!file.canRead()) {
        System.err.println(LogOut.e() + "No read-permission for file '" + file.getAbsolutePath() + "'");
        System.exit(1);
      }
      return file;
    }
  }

  public static File checkDirectory(String directoryname, boolean write) {
    File directory = new File(directoryname);
    if (!directory.exists()) {
      if (write) {
        // Create directory
        try {
          Files.createDirectory(directory.toPath());
        } catch (IOException e) {
          System.err.println("Cannot create directory '" + directoryname + "' (exception: " + e.getMessage() + ")");
          System.exit(1);
        }
      } else {
        System.err.println(LogOut.e() + "Directory '" + directoryname + "' does not exist");
        System.exit(1);
      }
    }
    if (!directory.canExecute() && !directory.canRead()) {
      System.err.println(LogOut.e() + "Directory '" + directoryname + "' is not possible to read from");
      System.exit(1);
    } else {
      if (write) {
        File testFile = new File(directoryname + "/testfile");
        try {
          Files.writeString(testFile.toPath(), "");
          Files.delete(testFile.toPath());
          return directory;
        } catch (IOException e) {
          System.err.println(LogOut.prefix("ERROR") + "Cannot write to directory '" + directoryname + "' (exception: " + e.getMessage() + ")");
          System.exit(1);
        }
      } else {
        return directory;
      }
    }
    return null; // System exists before this anyway
  }


  public static String parseString(List<String> initArgsList, String option) {
    // Search for option in initArgsList
    // If found, remove this element and return the next
    // If not found, return null

    Iterator<String> it = initArgsList.iterator();
    while (it.hasNext()) {
      String s = it.next();
      if (s.equals(option)) { // example -s option
        it.remove();
        if (it.hasNext()) {
          String value = it.next();
          it.remove();
          return value;
        } else {
          return null;
        }
      } else if (s.startsWith(option)) { // example -soption
        it.remove();
        if (s.length() > 1)
          return s.substring(2);
        else
          return null;
      }
    }
    return null;
  }

  public static boolean parseBoolean(List<String> initArgsList, String option) {
    // Search for option in initArgsList
    // If found, remove this element and return true
    // If not found, return false

    Iterator<String> it = initArgsList.iterator();
    while (it.hasNext()) {
      String s = it.next();
      if (s.equals(option)) {
        it.remove();
        return true;
      }
    }
    return false;
  }

  public static int parseInt(List<String> initArgsList, String option, int min, int max, int defaultValue) {
    // Search for arg in initArgsList that starts with option
    // If found, parse the rest of the arg as an int, then remove the element and return the int, but restricted between min and max
    // If not found, return default

    Iterator<String> it = initArgsList.iterator();
    while (it.hasNext()) {
      String s = it.next();
      if (s.startsWith(option)) {
        it.remove();
        String assumedIntPart = s.substring(option.length());
        try {
          int i = Integer.parseInt(assumedIntPart);
          if (i < min) {
            System.out.println(LogOut.w() + "Value for " + option + " [" + assumedIntPart + "] is lower than " + min + ", set to " + min);
            i = min;
          }
          if (i > max) {
            System.out.println(LogOut.w() + "Value for " + option + " [" + assumedIntPart + "] is higher than " + max + ", set to " + max);
            i = max;
          }
          return i;
        } catch (NumberFormatException e) {
          System.out.println(LogOut.w() + "Value for " + option + " [" + assumedIntPart + "] is not an int, set to default " + defaultValue);
          return defaultValue;
        }
      }
    }
    return defaultValue;
  }

  public static List<String> removeLeftoverOptions(List<String> initArgsList) {
    // Remove all options from initArgsList
    Iterator<String> it = initArgsList.iterator();
    while (it.hasNext()) {
      String s = it.next();
      if (s.startsWith("-")) {
        it.remove();
      }
    }
    return initArgsList;
  }
}
