package no.statnett.ecp.utils;

import no.statnett.ecp.brs.Config;
import no.statnett.ecp.brs.Login;
import no.statnett.ecp.brs.state.QueueInfo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public class SimpleParser {
    public static Integer getInt(String input) {
        return getInt(input, true);
    }

    public static Integer getInt(String input, boolean required) {
        try {
            // find first position of a digit or '-' (=45) in the input string
            int i = 0;
            while (i < input.length() && input.charAt(i) != 45 && !Character.isDigit(input.charAt(i)))
                i++;
            if (input.length() > i)
                return Integer.parseInt(input.substring(i));
            else {
                if (required)
                    System.out.println("Expected a number after the command, command ignored");
                return null;
            }
        } catch (NumberFormatException e) {
            if (required)
                System.out.println("Invalid number: " + input.substring(1) + ", command ignored");
            return null;
        }
    }

    public static String findStringInElement(String json, String key) {
        int offset = key.length() + 3;
        int keyPos = json.indexOf("\"" + key + "\":") + offset;
        int valueStartPos = json.indexOf("\"", keyPos) + 1;
        int valueEndPos = json.indexOf("\"", valueStartPos);
        if (keyPos < offset || valueEndPos < 0)
            return "";
        return json.substring(valueStartPos, valueEndPos);
    }

    public static String findNumberInElement(String json, String key) {
        int offset = key.length() + 3;
        int numberPosStart = json.indexOf("\"" + key + "\":") + offset;
        if (numberPosStart < offset)
            return "-1";
        int numberPosEnd = json.indexOf(",", numberPosStart);
        if (numberPosEnd == -1)
            numberPosEnd = json.indexOf("}", numberPosStart);
        if (numberPosEnd == -1)
            return json.substring(numberPosStart).trim();
        else
            return json.substring(numberPosStart, numberPosEnd).trim();
    }
}
