package no.statnett.ecp.cds.state;

import java.util.Map;
import java.util.TreeMap;

public class Component {
    private String code;
    private String email;
    private String name;
    private String phone;
    private String org;
    private String created;
    private String version;
    private String lastModification;
    private String type;
    private String validTo;
    private String syncTimestamp;
    private String syncStatus;
    private String cdCode;

    private Map<Integer, MessagePathInfo> mpiMap = new TreeMap<>();
    private Map<String, Boolean> connectedMap = new TreeMap<>();
    private int mpCount;


    public Component() {

    }

    public Component(String code, String email, String name, String phone, String org, String created, String version, String lastModification, String type, String validTo, String cdCode) {
        this.code = code;
        this.email = email;
        this.name = name;
        this.phone = phone;
        this.org = org;
        this.created = created;
        this.version = version;
        this.lastModification = lastModification;
        this.type = type;
        this.validTo = validTo;
        this.cdCode = cdCode;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public String getEmail() {
        return email;
    }

    public String getName() {
        return name;
    }

    public String getOrg() {
        return org;
    }

    public String getVersion() {
        return version;
    }

    public String getType() {
        return type;
    }

    public String getValidTo() {
        return validTo;
    }

    public String getCdCode() {
        return cdCode;
    }

    public String toString() {
        return code + " | " + " | " + type + " | " + version + " | " + validTo + " | " + syncTimestamp + "(" + syncStatus + ")" + " | " + org + " | " + email;
    }

    public void setSyncTimestamp(String timestamp) {
        this.syncTimestamp = timestamp;
    }

    public String getSyncTimestamp() {
        return syncTimestamp;
    }

    public String getSyncStatus() {
        return syncStatus;
    }

    public void setSyncStatus(String syncStatus) {
        this.syncStatus = syncStatus;
    }

    public Map<Integer, MessagePathInfo> getMpiMap() {
        return mpiMap;
    }

    public Map<String, Boolean> getConnectedMap() {
        return connectedMap;
    }

    public int getMpCount() {
        return mpCount;
    }

    public void setMpCount(int mpCount) {
        this.mpCount = mpCount;
    }

    // Composite field, made up by syncTimestamp and syncStatus
    public String getSync() {
        if (syncStatus == null) {
            return "null (--)";
        } else {
            return syncTimestamp + " (" + syncStatus + ")";
        }
    }
}
