package no.statnett.ecp.cds.state;

import java.util.List;

public class ComponentFilter {

  private FilterResult csrt;
  private FilterResult csch;
  private FilterResult cver;
  private FilterResult cval;
  private FilterResult cscp;
  private FilterResult cmpc;
  private FilterResult clim;
  private FilterResult cacl;

  public ComponentFilter() {
    reset();
  }

  public void reset() {
    csrt = new FilterResult("=", 0, null); // Default sort - no sorting
    csch = new FilterResult(null, null, null); // Default filter - matches ALL
    cver = new FilterResult(null, null, null); // Default filter - matches ALL
    cval = new FilterResult(null, null, null); // Default filter - matches ALL
    cscp = new FilterResult(null, null, null); // Default filter - matches ALL
    cmpc = new FilterResult("=", -1, null); // Default filter - matches ALL
    clim = new FilterResult("=", 0, null); // Default listing - lists ALL
    cacl = new FilterResult(null, null, null); // Default listing - lists ALL
  }

  // Special case for FAMonitor (a CDShell fork) - not available in CDShell
  private List<String> endpoints;

  public FilterResult getCsrt() {
    return csrt;
  }

  public void setCsrt(FilterResult csrt) {
    this.csrt = csrt;
  }

  public FilterResult getCsch() {
    return csch;
  }

  public void setCsch(FilterResult csch) {
    this.csch = csch;
  }

  public FilterResult getCver() {
    return cver;
  }

  public void setCver(FilterResult cver) {
    this.cver = cver;
  }

  public FilterResult getCval() {
    return cval;
  }

  public void setCval(FilterResult cval) {
    this.cval = cval;
  }

  public FilterResult getCscp() {
    return cscp;
  }

  public void setCscp(FilterResult cscp) {
    this.cscp = cscp;
  }

  public FilterResult getCmpc() {
    return cmpc;
  }

  public void setCmpc(FilterResult cmpc) {
    this.cmpc = cmpc;
  }

  public List<String> getEndpoints() {
    return endpoints;
  }

  public void setEndpoints(List<String> endpoints) {
    this.endpoints = endpoints;
  }

  public FilterResult getClim() {
    return clim;
  }

  public void setClim(FilterResult clim) {
    this.clim = clim;
  }

  public FilterResult getCacl() {
    return cacl;
  }

  public void setCacl(FilterResult cacl) {
    this.cacl = cacl;
  }
}
