package no.statnett.ecp.cds.state;

public class MessagePathFilter {

  private FilterResult msrt;
  private FilterResult msta;
  private FilterResult mcod;
  private FilterResult mbro;
  private FilterResult mtyp;
  private FilterResult mlim;

  public MessagePathFilter() {
    reset();
  }

  public void reset() {
    msrt = new FilterResult("=", 0, null);  // Default sort - no sorting
    msta = new FilterResult(null, null, null); // Default filter - matches ALL
    mcod = new FilterResult(null, null, null); // Default filter - matches ALL
    mbro = new FilterResult(null, null, null); // Default filter - matches ALL
    mtyp = new FilterResult(null, null, null); // Default filter - matches ALL
    mlim = new FilterResult("=", 0, null); // Default listing - lists ALL

  }

  public String getStatExplained() {
    if (msta.arg() == null || msta.arg().equals("aaaa")) {
      return "<ALL>";
    } else {
      String statExplained = msta.arg() + " (";
      char c = msta.arg().charAt(0);
      if (c == 'a') {
        statExplained += "Valid & Invalid, ";
      } else if (c == 'y') {
        statExplained += "Only Valid, ";
      } else if (c == 'n') {
        statExplained += "Only Invalid, ";
      } else if (c == '?') {
        statExplained += "Unknown Validity, ";
      }

      c = msta.arg().charAt(1);
      if (c == 'a') {
        statExplained += "Connected & Disconnected, ";
      } else if (c == 'y') {
        statExplained += "Only Connected, ";
      } else if (c == 'n') {
        statExplained += "Only Disconnected, ";
      } else if (c == '?') {
        statExplained += "Unknown ConnectStatus, ";
      }

      c = msta.arg().charAt(2);
      if (c == 'a') {
        statExplained += "Local & Central, ";
      } else if (c == 'y') {
        statExplained += "Only Local, ";
      } else if (c == 'n') {
        statExplained += "Only Central, ";
      } else if (c == '?') {
        statExplained += "Central failed, ";
      }

      c = msta.arg().charAt(3);
      if (c == 'a') {
        statExplained += "Active & Inactive";
      } else if (c == 'y') {
        statExplained += "Only Active";
      } else if (c == 'n') {
        statExplained += "Only Inactive";
      } else if (c == '?') {
        statExplained += "Unknown Status";
      }
      statExplained += ")";
      return statExplained;
    }
  }

  public FilterResult getMsrt() {
    return msrt;
  }

  public void setMsrt(FilterResult msrt) {
    this.msrt = msrt;
  }

  public FilterResult getMsta() {
    return msta;
  }

  public void setMsta(FilterResult msta) {
    this.msta = msta;
  }

  public FilterResult getMcod() {
    return mcod;
  }

  public void setMcod(FilterResult mcod) {
    this.mcod = mcod;
  }

  public FilterResult getMbro() {
    return mbro;
  }

  public void setMbro(FilterResult mbro) {
    this.mbro = mbro;
  }

  public FilterResult getMtyp() {
    return mtyp;
  }

  public void setMtyp(FilterResult mtyp) {
    this.mtyp = mtyp;
  }

  public FilterResult getMlim() {
    return mlim;
  }

  public void setMlim(FilterResult mlim) {
    this.mlim = mlim;
  }
}
