package no.statnett.ecp.div;

import jakarta.jms.*;
import no.statnett.ecp.utils.Broker;
import no.statnett.ecp.utils.URLParser;

import javax.naming.NamingException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BrannslukkerAFRRCAPBudTilNVE {


    public static void main(String[] args) throws IOException, NamingException, JMSException, NoSuchAlgorithmException, KeyManagementException {
        if (args.length < 5 || args.length > 7) {
            usage();
            System.exit(1);
        }

        // <EDX-DMS-path> <ReceiverCode> <BusinessType> BROKER QUEUE [KEYSTORE]
        String EDXDMSPath = args[0];
        String receiverCode = args[1];
        String messageType = args[2];
        String urlPathArg = args[3];
        String queue = args[4];
        String keystoreFile = args.length > 5 ? args[5] : null;
        String keystorePW = args.length > 6 ? args[6] : null;

        // Finn alle filer for i dag
        List<Path> files = Files.find(Paths.get(EDXDMSPath), 999, (p, bfa) -> bfa.isRegularFile() && LocalDate.ofInstant(bfa.creationTime().toInstant(), ZoneId.systemDefault()).compareTo(LocalDate.now()) == 0).collect(Collectors.toList());

        // Finn den bestemte filen
        int fileCount = 0;
        boolean fileMatch = false;
        String modifiedFileStr = null;
        for (Path file : files) {
            fileCount++;
            List<String> lines = Files.readAllLines(file, Charset.defaultCharset());
            boolean typeMatch = false;
            boolean processMatch = false;
            boolean receiverMatch = false;
            boolean auctionMatch = false;
            for (String line : lines) {
                if (line.contains("<type>A38</type>")) {
                    typeMatch = true;
                } else if (line.contains("<process.processType>A51</process.processType>")) {
                    processMatch = true;
                } else if (line.contains("<receiver_MarketParticipant.mRID codingScheme=\"A01\">10X1001A1001A38Y</receiver_MarketParticipant.mRID>")) {
                    receiverMatch = true;
                } else if (line.contains("<auction.mRID>AFRR_CAPACITY_MARKET</auction.mRID>")) {
                    auctionMatch = true;
                }
            }
            // Filtrer filen
            if (typeMatch && processMatch && receiverMatch && auctionMatch) {
                fileMatch = true;
                boolean insideTimeSeries = false;
                StringBuilder modifiedFile = new StringBuilder();
                StringBuilder oneTimeSeriesSB = new StringBuilder();
                for (String line : lines) {
                    if (line.contains("<TimeSeries>")) {
                        insideTimeSeries = true;
                        oneTimeSeriesSB.append(line);
                    } else if (line.contains("</TimeSeries>")) {
                        insideTimeSeries = false;
                        oneTimeSeriesSB.append(line);
                        String oneTimeSeriesStr = oneTimeSeriesSB.toString();
                        if (oneTimeSeriesStr.contains("<connecting_Domain.mRID codingScheme=\"A01\">10Y1001A1001A48H") || oneTimeSeriesStr.contains("<connecting_Domain.mRID codingScheme=\"A01\">10YNO-")) {
                            modifiedFile.append(oneTimeSeriesStr);
                            oneTimeSeriesSB = new StringBuilder();
                        } else {
                            oneTimeSeriesSB = new StringBuilder();
                        }
                    } else if (insideTimeSeries) {
                        oneTimeSeriesSB.append(line);
                    } else if (!insideTimeSeries) {
                        modifiedFile.append(line);
                    }
                }
                modifiedFileStr = modifiedFile.toString();
                break; // Vi har funnet en match og filtrert denne matchen
            }
        }
        // Send filen
        if (fileMatch) {
            Map<String, String> config = URLParser.parse(urlPathArg, true);
            Connection connection = Broker.createAndStartConnection(config);
            Session session = connection.createSession(false, jakarta.jms.Session.AUTO_ACKNOWLEDGE);
            jakarta.jms.Destination destination = session.createQueue(queue);


//      Context context = AMQPConnector.getContext(true, config, queue);
//      Connection connection = AMQPConnector.createSession(context);
//      Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
            MessageProducer producer = session.createProducer(destination);
            BytesMessage message = buildBytesMessage(session, modifiedFileStr.getBytes(StandardCharsets.UTF_8), receiverCode, messageType);
            producer.send(message);
            producer.close();
            System.out.println("Message with size " + modifiedFileStr.length() + "B was sent to " + receiverCode + " with messageType " + messageType);
        } else {
            System.err.println("1 - Found " + fileCount + " files from today (after midnight) in " + args[0] + ", but no file matched.");
            System.exit(1);
        }
    }

    public static BytesMessage buildBytesMessage(final Session session, final byte[] message, String receiverCode, String messageType) throws JMSException {
        final BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(message);
        setMessageProperties(bytesMessage, receiverCode, messageType);
        return bytesMessage;
    }

    private static void setMessageProperties(final Message message, String receiverCode, String messageType) throws JMSException {
        message.setStringProperty("receiverCode", receiverCode);
        message.setStringProperty("messageType", messageType);
        message.setStringProperty("businessType", messageType);
        message.setStringProperty("senderApplication", "AMQPConnector");
        // More headers could be specified, but are not mandatory - see EDX User Guide chapter 5.
    }


    private static void usage() {
        System.out.println("BrannslukkerAFRRCAPBudTilNVE (ACNVE) v0.9.4"); // Ikke prodsatt, kjører 0.9.2 i prod med gamle biblioteker (qpid-jms-0.32.0)
        System.out.println("Usage  : java -jar ekit.jar ACNVE <EDX-DMS-path> <ReceiverCode> <BusinessType> BROKER QUEUE [KEYSTORE]\n");
        System.out.println("Example: java -jar ekit.jar ACNVE /var/lib/edx-toolbox/edx-dms 50V000000000126J MO-MCC-BIDS-TO-STATNETT /etc/edx-toolbox/ edx.endpoint.outbox /var/lib/ecp-endpoint/authKeystore.jks password");

        System.out.println("\n\nThe options and arguments:");
        System.out.println(" <EDX-DMS-PATH>: Path to EDX-DMS (/var/lib/edx-toolbox/edx-dms - Recursive search will be performed");
        System.out.println(" <ReceiverCode>: ECP-component-code (if connecting to ECP) or EDX Address (if connecting to EDX)");
        System.out.println(" <BusinessType>: EDX BusinessType (same as ECP MessageType)");
        System.out.println(" BROKER        : <URL|PATH> - either specify a URL to a broker or a path for the ECP- or EDX-configuration");
        System.out.println("                 URL                : Specify url starting with either 'amqp' or 'amqps' + keystore-file/password args at the end");
        System.out.println("                 PATH               : Specify either the conf-path for ECP or EDX (ex: /etc/ecp-endpoint or /etc/edx-toolbox)");
        System.out.println(" QUEUES        : Name of queue to produce/send to - should be a proper outbox");
        System.out.println(" KEYSTORE        <keystore-file> <keystore-password> - these two parameters are only necessary if you specify 'amqps' as URL argument. ");
        System.out.println("                                                       If they are specified they will override keystore params found in PATH-config");

        System.out.println("\n\nThe brannslukker will search EDX-DMS and find at maximum one file for today with the following content:");
        System.out.println("\t<type>A38</type>");
        System.out.println("\t<process.processType>A51</process.processType>");
        System.out.println("\t<receiver_MarketParticipant.mRID codingScheme=\"A01\">10X1001A1001A38Y</receiver_MarketParticipant.mRID>");
        System.out.println("\t<auction.mRID>AFRR_CAPACITY_MARKET</auction.mRID>");
        System.out.println("\nThen it will filter the XML to rid it of all TimeSeries which does not contain one of the following:");
        System.out.println("\t<connecting_Domain.mRID codingScheme=\"A01\">10Y1001A1001A48H"); // NO5
        System.out.println("\t<connecting_Domain.mRID codingScheme=\"A01\">10YNO-"); // Dekker NO-1-4
        System.out.println("\nThen it will take the modified XML and send it to <ReceiverCode> with the <BusinessType> specified using the specified BROKER+QUEUE");
        System.out.println("The program will exit with 0 or 1 followed by a message. 0=Success, 1=Try again");
    }

}
