package no.statnett.ecp.div;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SC {
  public static String VERSION = "v1.0.0";
  public static void main(String[] args) throws IOException {
    if (args.length <= 2 || args.length > 4) {
      usage();
      System.exit(1);
    }
    List<String> services = Files.readAllLines(Path.of(args[2]));
    Map<String, String> toolboxes = new TreeMap<>();
    if (args.length == 4) {
      for (String line : Files.readAllLines(Path.of(args[3]))) {
        if (line.trim().equals(""))
          continue;
        toolboxes.put(line.split(";")[0], line.split(";")[1]);
      }
    }

    String action = args[1];
    if (action.equals("s")) {
      System.out.println("  <services>");
      for (String service : services) {
        if (service.trim().equals(""))
          continue;
        String serviceCode = service.split(";")[0];
        String serviceDescription = service.split(";")[2];
        System.out.println("    <service>");
        System.out.println("      <serviceCode v=\"" + serviceCode + "\"/>");
        System.out.println("      <name v=\"" + serviceCode + "\"/>");
        System.out.println("      <description v=\"" + serviceDescription + "\"/>");
        System.out.println("    </service>");
      }
      System.out.println("  </services>");
    }

    if (action.equals("c")) {
      System.out.println("    <serviceConsumers>");
      for (String service : services) {
        if (service.trim().equals(""))
          continue;
        String serviceCode = service.split(";")[0];
        String providerCode = service.split(";")[1];
        System.out.println("      <consumer>");
        System.out.println("        <serviceCode v=\"" + serviceCode + "\"/>");
        System.out.println("        <providers>");
        System.out.println("          <serviceProvider>");
        System.out.println("            <toolbox v=\"" + providerCode + "\"/>");
        System.out.println("            <primary v=\"true\"/>");
        System.out.println("          </serviceProvider>");
        System.out.println("        </providers>");
        System.out.println("      </consumer>");
      }
      System.out.println();
      System.out.println("    </serviceConsumers>");
    }

    if (action.equals("p")) {
      Map<String, List<String>> serviceCodesPrProviderCode = findServiceCodesPrProviderCode(services, toolboxes);
      for (String providerCode : serviceCodesPrProviderCode.keySet()) {
        System.out.println("  <toolbox>");
        System.out.println("    <code v=\"" + providerCode + "\"/>");
        System.out.println("    <name v=\"" + toolboxes.get(providerCode) + "\"/>");
        System.out.println("    <party v=\"PARTY\"/>");
        System.out.println("    <version v=\"1.10.0.1179\"/>");
        System.out.println("    <publications/>");
        System.out.println("    <serviceProviders>");
        for (String serviceCode : serviceCodesPrProviderCode.get(providerCode)) {
          System.out.println("      <provider>");
          System.out.println("        <serviceCode v=\"" + serviceCode + "\"/>");
          System.out.println("      </provider>");
        }
        System.out.println("    </serviceProviders>");
        System.out.println("    <serviceConsumers>");
        for (String serviceCode : serviceCodesPrProviderCode.get(providerCode)) {
          System.out.println("      <consumer>");
          System.out.println("        <serviceCode v=\"" + serviceCode + "\"/>");
          System.out.println("        <providers>");
          System.out.println("          <serviceProvider>");
          System.out.println("            <toolbox v=\"" + providerCode + "\"/>");
          System.out.println("            <primary v=\"true\"/>");
          System.out.println("          </serviceProvider>");
          System.out.println("        </providers>");
          System.out.println("      </consumer>");
        }
        System.out.println("    </serviceConsumers>");
        System.out.println("    <physicalNetworks><physicalNetworkCode v=\"internet\"/></physicalNetworks>");
        System.out.println("  </toolbox>");
      }
    }

    if (action.equals("t")) {
      Map<String, List<String>> serviceCodesPrProviderCode = findServiceCodesPrProviderCode(services, toolboxes);
      for (String toolboxCode : toolboxes.keySet()) {
        if (serviceCodesPrProviderCode.get(toolboxCode) != null) {
          continue; // Do not make a toolbox for a provider
        }
        System.out.println("  <toolbox>");
        System.out.println("    <code v=\"" + toolboxCode + "\"/>");
        System.out.println("    <name v=\"" + toolboxes.get(toolboxCode) + "\"/>");
        System.out.println("    <party v=\"PARTY\"/>");
        System.out.println("    <version v=\"1.10.0.1179\"/>");
        System.out.println("    <publications/>");
        System.out.println("    <serviceProviders/>");
        System.out.println("    <serviceConsumers/>");
        System.out.println("    <physicalNetworks><physicalNetworkCode v=\"internet\"/></physicalNetworks>");
        System.out.println("  </toolbox>");
      }
    }
  }

  private static Map<String, List<String>> findServiceCodesPrProviderCode(List<String> services, Map<String, String> toolboxes) {
    if (toolboxes.size() == 0) {
      System.out.println("ERROR: Missing toolbox-codes (file is missing or no toolboxes are listed");
      usage();
      System.exit(1);
    }
    Map<String, List<String>> serviceCodesPrProviderCode = new TreeMap<>();
    for (String service : services) {
      if (service.trim().equals(""))
        continue;
      String serviceCode = service.split(";")[0];
      String providerCode = service.split(";")[1];
      List<String> serviceCodeList = serviceCodesPrProviderCode.get(providerCode);
      if (serviceCodeList == null) {
        serviceCodeList = new ArrayList<>();
        serviceCodesPrProviderCode.put(providerCode, serviceCodeList);
      }
      serviceCodeList.add(serviceCode);
    }
    return serviceCodesPrProviderCode;
  }

  private static void usage() {
    System.out.println("SC v0.93 is a tool to make parts of the EDX Service Catalogue. Supports only 'old-syntax' (v1) for now. Party is always set to PARTY.");
    System.out.println("Usage: java -jar ekit.jar SC v1 s|c|p|t <service-file> [<toolbox-codes>]");
    System.out.println("Arguments explained:");
    System.out.println("s               Uses <service-file> to produce the <services>-tag");
    System.out.println("c               Uses <service-file> to produce all services in one single <serviceconsumer>-tag");
    System.out.println("p               Uses <service-file> + <toolbox-codes> to produce all <toolbox> that is a producer");
    System.out.println("t               Uses <service-file> + <toolbox-codes> to produce all <toolbox> that is not a producer");
    System.out.println("<service-file>  Path to file where each line has the format: <ServiceCode>;<ECPCode>;<Description>, example: MMS;50V-SN-DK----ATT;Bla bla");
    System.out.println("<toolbox-codes> Path to file where each line has the format: <ECPCode>;<Name>, example: 50V-SN-DK----ATT;Statnett DK ");
    System.out.println("\n\nExample 1 - make the complete list of services provided:");
    System.out.println("java -jar ekit.jar SC v1 s services.txt");
    System.out.println("Example 2 - make the complete list of 'simple' toolboxes, e.g. those that does not have a provider:");
    System.out.println("java -jar ekit.jar SC v1 t services.txt toolboxes.txt");
    System.out.println("\nPro tip 1: To produce toolbox-codes, export 'Components List' (button in CD v4.10) - then edit to match requirements");
    System.out.println("Pro tip 2: To produce service-file, export newest network-config, start excel, press 'Open' in excel - choose network-config, convert from XML to table - then edit to match requirements");
  }
}
