package no.statnett.ecp.em;

public class Message {

    public static final long KILO = 1024L;

    private String messageId; // id
    private boolean snd; // snd/rcv
    private long bytes = -1L; // if no size is not found - default will be -1 to indicate that it is not set
    private long ms = 0L; // duration, default 0, if still 0 after log-parsing it means the message has expired
    private long tms; // epochTms
    private long tmpTms; // epochTms-start
    private long tmsHour; // yyyyMMddHH
    private long tmsMinute; // yyyyMMddHHmm
    private int quarterHour; // an integer representing a specific quarter of an hour. quarterHour = 0 means first quarter from 2020-01-01 00:00:00-00:14:59
    private String week; // yyyy'W'ww
    private String sender; // ecp-code
    private String senderApplication;
    private String receiver; // ecp-code
    private String broker; // ecp-code
    private String messageType;
    private String baMessageId;
    private String ackStatus = "?"; // ?/Y/N/-

    public Message(String messageId, boolean snd) {
        this.messageId = messageId;
        this.snd = snd;
    }

    public String getMessageId() {
        return messageId;
    }

    public String getDirection() {
        return snd ? "SEND,   " : "RECEIVE,";
    }

    public long getKB() {
        return bytes / KILO;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public long getMs() {
        return ms;
    }

    public void setMs(long ms) {
        this.ms = ms;
    }

    public long getTms() {
        return tms;
    }

    public void setTms(long tms) {
        this.tms = tms;
    }

    public long getTmpTms() {
        return tmpTms;
    }

    public void setTmpTms(long tmpTms) {
        this.tmpTms = tmpTms;
    }

    public long getTmsHour() {
        return tmsHour;
    }

    public void setTmsHour(long tmsHour) {
        this.tmsHour = tmsHour;
    }

    public long getTmsMinute() {
        return tmsMinute;
    }

    public void setTmsMinute(long tmsMinute) {
        this.tmsMinute = tmsMinute;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSenderApplication() {
        return senderApplication;
    }

    public void setSenderApplication(String senderApplication) {
        this.senderApplication = senderApplication;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getOppositeEP() {
        return snd ? receiver : sender;
    }

    public String getMeasureEP() {
        return snd ? sender : receiver;
    }

    public String getBroker() {
        return broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getBaMessageId() {
        return baMessageId;
    }

    public void setBaMessageId(String baMessageId) {
        this.baMessageId = baMessageId;
    }

    public String getAckStatus() {
        return ackStatus;
    }

    public void setAckStatus(String ackStatus) {
        this.ackStatus = ackStatus;
    }

    public int getQuarterHour() {
        return quarterHour;
    }

    public void setQuarterHour(int quarterHour) {
        this.quarterHour = quarterHour;
    }

    public String getWeek() {
        return week;
    }

    public void setWeek(String week) {
        this.week = week;
    }
}
