package no.statnett.ecp.utils;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

import static java.time.ZoneOffset.UTC;

public class Const {
  public static final DateTimeFormatter localTmsMillisec = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
  public static final DateTimeFormatter localTmsMillisecNotISO = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
  public static final DateTimeFormatter localTmsSec = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
  public static final DateTimeFormatter localTmsSecNotISO = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
  public static final DateTimeFormatter utcTmsMillisec = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
  public static final DateTimeFormatter utcTmsSec = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
  public static final DateTimeFormatter tmsNumberMillisec = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
  public static final DateTimeFormatter tmsNumberSec = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
  public static final DateTimeFormatter tmsNumberMinute = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
  public static final DateTimeFormatter tmsNumberHour = DateTimeFormatter.ofPattern("yyyyMMddHH");
  public static final DateTimeFormatter tmsNumberWeek = DateTimeFormatter.ofPattern("yyyy'W'ww", new Locale("no", "NO"));
  public static final long MS_20200101 = ZonedDateTime.of(2020, 1, 1, 0, 0, 0, 0, UTC).toInstant().toEpochMilli();
  public static final long MS_QUARTERHOUR = 900000L;
}
