package no.statnett.ecp.utils;

import java.time.ZonedDateTime;

public class EcpEdxLog {
    /*
     * Search for and find certain elements in a log-line from ecp.log or edx.log
     */

    public static String findEdxMessageIDInLogLine(String line) {
        return getString(line, "edxMessageID=", ",");
    }

    public static String findEdxMessageIdInLogLine(String line) {
        return getString(line, "edxMessageId=", ",");
    }

    public static String findMessageIDInLogLine(String line) {
      return getString(line, "messageID=", ",");
    }

    public static String findEcpMessageIDInLogLine(String line) {
        return getString(line, "ecpMessageId=", ",");
    }

    public static String findUploadBrokerInLogLine(String s) {
        return getString(s, "uploaded to ", ".,");
    }

    public static String findDownloadBrokerInLogLine(String s) {
        return getString(s, "has been received from ", ".,");
    }

    public static String findReceiverCodeInLogLine(String s) {
        return getString(s, "receiverCode=", ",");
    }

    public static String findSenderCodeInLogLine(String s) {
        return getString(s, "senderCode=", ",");
    }

    public static String findBusinessTypeInLogLine(String s) {
        return getString(s, "businessType=", ",");
    }

    public static String findBaMessageIdInLogLine(String s) {
        return getString(s, "baMessageID=", ",");
    }

    public static String getString(String line, String startPhrase, String endPhrase) {
        int startPhrasePos = line.indexOf(startPhrase);
        if (startPhrasePos == -1) {
            return null;
        }
        int idPosStart = startPhrasePos + startPhrase.length();
        int idPosSlutt = line.indexOf(endPhrase, idPosStart);
        String s = line.substring(idPosStart, idPosSlutt);
        // Ecp-logs from SC-ECP seem to have values in single quotes from time to time...we remove them
        if (s.startsWith("'")) {
            s = s.substring(1);
        }
        if (s.endsWith("'")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static long findGeneratedTmsInLogLine(String s) {
        int idPosStart = s.indexOf("generated=") + "generated=".length(); //
        int idPosSlutt = s.indexOf("]]", idPosStart) + 1; // inkluderer "]" i tms
        String tmsStr = s.substring(idPosStart, idPosSlutt);
        return ZonedDateTime.parse(tmsStr).toInstant().toEpochMilli();
    }

    public static long findPayloadSizeInLogLine(String s) {
        int idPosStart = s.indexOf("payloadSize=") + "payloadSize=".length();
        int idPosSlutt = s.indexOf(".,", idPosStart);
        return Long.parseLong(s.substring(idPosStart, idPosSlutt));

    }

    public static String findSenderApplicationInLogLine(String s) {
        return getString(s, "senderApplication=", ",");
    }
}
